﻿$(document).ready(function () {
    var content = $("ul.resources");

    content.on("click", ".resource .heading a.toggle, .resource .heading a.toggleMain", function () {
        var items = $(this).closest("li.resource");
        $("ul.endpoints li.endpoint", items).toggle("slow");
    });

    content.on("click", ".resource .heading .options a.list", function () {
        var items = $(this).closest("li.resource");
        ensureSectionIsVisible(items);
        $("ul.endpoints ul.operations li.operation .content", items).hide("slow");
    });

    content.on("click", ".resource .heading .options a.expand", function () {
        var items = $(this).closest("li.resource");
        ensureSectionIsVisible(items);
        $("ul.endpoints ul.operations li.operation .content", items).show("slow");
    });

    content.on("click", "li.operation a.toggleSingle", function () {
        var li = $(this).closest("li");
        $(".content", li).toggle("slow");
    });

    function ensureSectionIsVisible(section) {
        $("ul.endpoints li.endpoint", section).show("slow");
    }

    content.on("click", ".resource .heading a.toggleContent", function (event) {
        var parent = $(this).closest("li.resource");
        $("ul.operations", parent).toggle("slow");
        event.stopPropagation();
    });

    content.on("click", ".resource .innerHeader .toggleInner", function (event) {
        var parent = $(this).closest("td");
        $("table.innerTable:first", parent).toggle("slow");
        event.stopPropagation();
    });

    content.on("click", "ul.operations a.customType", function (event) {
        $(".container .customTypes").show();
        //document.location = $(this).attr("data-href");
    });
});